import React from 'react';
import { render } from 'react-dom';
import { AppContainer } from 'react-hot-loader';
import { configureStore, history } from 'store/configureStore';
import { loadPersistedState } from 'store/persistedStore';
import App from 'components/App/App';
import './app.global.css';

const persistedState = loadPersistedState();
const store = configureStore(persistedState);

render(
  <AppContainer>
    <App store={store} history={history} />
  </AppContainer>,
  document.getElementById('root')
);

if (module.hot) {
  module.hot.accept('./components/App/App', () => {
    // eslint-disable-next-line global-require
    const NextRoot = require('./components/App/App').default;
    render(
      <AppContainer>
        <NextRoot store={store} history={history} />
      </AppContainer>,
      document.getElementById('root')
    );
  });
}
